'use strict';

parcel_services.controllers.module('create-modal', ['xhr', gx.source + '/libs/info_messages'], function () {
	return {
		vue: true,
		name: 'gx-create-modal',
		template: '#create-modal',
		parent: 'gx-parcel-services-overview',
		props: ['languages'],
		data: function data() {
			return {
				lang: {
					title: jse.core.lang.translate('create_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('create', 'buttons'),
					labels: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_set_as_default', 'parcel_services'),
						comment: jse.core.lang.translate('label_comment', 'parcel_services'),
						url: jse.core.lang.translate('label_url', 'parcel_services'),
						placeholder: jse.core.lang.translate('label_tracking_number_placeholder', 'parcel_services')
					}
				},
				details: {
					name: '',
					isDefault: false,
					descriptions: {}
				},
				validFormData: {
					name: true
				},
				selectedLanguage: ''
			};
		},
		methods: {
			resetModal: function resetModal() {
				this.details.name = '';
				this.details.isDefault = false;
				this.descriptions = [];
				for (var i in this.languages) {
					this.details.descriptions[this.languages[i].id] = {
						languageId: this.languages[i].id,
						url: '',
						comment: ''
					};
				}
				this.validFormData.name = true;
				if (this.$children[0] !== undefined) {
					this.$children[0].input = this.details.isDefault;
				}
			},
			confirm: function confirm() {
				var _this = this;

				if (this.checkFormData() === false) {
					return;
				}

				jse.libs.xhr.post({
					url: './api/parcel-services',
					data: this.details
				}).done(function (response) {
					_this.$emit('reload-overview');
				}).fail(function (response) {
					console.error('Could not create parcel service.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_create_parcel_service', 'parcel_services'));
				});
				$('.create-modal.modal').modal('hide');
			},
			checkFormData: function checkFormData() {
				this.validFormData.name = this.details.name.trim().length !== 0;

				return this.validFormData.name;
			},
			changeLanguage: function changeLanguage(languageId) {
				this.selectedLanguage = languageId;
				if (this.details.descriptions[languageId] === undefined) {
					this.details.descriptions[languageId] = {
						languageId: languageId,
						url: '',
						comment: ''
					};
				}
			},
			openModal: function openModal(details) {
				this.selectedLanguage = this.languages[0].id;
				this.resetModal();
				gx.widgets.init($('.create-modal.modal'));
				$('.create-modal.modal').modal('show');
			}
		},
		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhcmNlbF9zZXJ2aWNlcy9jcmVhdGUtbW9kYWwuanMiXSwibmFtZXMiOlsicGFyY2VsX3NlcnZpY2VzIiwiY29udHJvbGxlcnMiLCJtb2R1bGUiLCJneCIsInNvdXJjZSIsInZ1ZSIsIm5hbWUiLCJ0ZW1wbGF0ZSIsInBhcmVudCIsInByb3BzIiwiZGF0YSIsImxhbmciLCJ0aXRsZSIsImpzZSIsImNvcmUiLCJ0cmFuc2xhdGUiLCJjbG9zZSIsImNvbmZpcm0iLCJsYWJlbHMiLCJpc0RlZmF1bHQiLCJjb21tZW50IiwidXJsIiwicGxhY2Vob2xkZXIiLCJkZXRhaWxzIiwiZGVzY3JpcHRpb25zIiwidmFsaWRGb3JtRGF0YSIsInNlbGVjdGVkTGFuZ3VhZ2UiLCJtZXRob2RzIiwicmVzZXRNb2RhbCIsImkiLCJsYW5ndWFnZXMiLCJpZCIsImxhbmd1YWdlSWQiLCIkY2hpbGRyZW4iLCJ1bmRlZmluZWQiLCJpbnB1dCIsImNoZWNrRm9ybURhdGEiLCJsaWJzIiwieGhyIiwicG9zdCIsImRvbmUiLCIkZW1pdCIsImZhaWwiLCJyZXNwb25zZSIsImNvbnNvbGUiLCJlcnJvciIsImluZm9fbWVzc2FnZXMiLCJhZGRFcnJvciIsIiQiLCJtb2RhbCIsInRyaW0iLCJsZW5ndGgiLCJjaGFuZ2VMYW5ndWFnZSIsIm9wZW5Nb2RhbCIsIndpZGdldHMiLCJpbml0Il0sIm1hcHBpbmdzIjoiOztBQUFBQSxnQkFBZ0JDLFdBQWhCLENBQTRCQyxNQUE1QixDQUFtQyxjQUFuQyxFQUNDLENBQUMsS0FBRCxFQUFXQyxHQUFHQyxNQUFkLHlCQURELEVBRUMsWUFBTTtBQUNMLFFBQU87QUFDTkMsT0FBSyxJQURDO0FBRU5DLFFBQU0saUJBRkE7QUFHTkMsWUFBVSxlQUhKO0FBSU5DLFVBQVEsNkJBSkY7QUFLTkMsU0FBTyxDQUFDLFdBQUQsQ0FMRDtBQU1OQyxRQUFNO0FBQUEsVUFBTztBQUNaQyxVQUFNO0FBQ0xDLFlBQU9DLElBQUlDLElBQUosQ0FBU0gsSUFBVCxDQUFjSSxTQUFkLENBQXdCLG9CQUF4QixFQUE4QyxpQkFBOUMsQ0FERjtBQUVMQyxZQUFPSCxJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3QixRQUF4QixFQUFrQyxTQUFsQyxDQUZGO0FBR0xFLGNBQVNKLElBQUlDLElBQUosQ0FBU0gsSUFBVCxDQUFjSSxTQUFkLENBQXdCLFFBQXhCLEVBQWtDLFNBQWxDLENBSEo7QUFJTEcsYUFBUTtBQUNQWixZQUFNTyxJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3QixZQUF4QixFQUFzQyxpQkFBdEMsQ0FEQztBQUVQSSxpQkFBV04sSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0Isc0JBQXhCLEVBQWdELGlCQUFoRCxDQUZKO0FBR1BLLGVBQVNQLElBQUlDLElBQUosQ0FBU0gsSUFBVCxDQUFjSSxTQUFkLENBQXdCLGVBQXhCLEVBQXlDLGlCQUF6QyxDQUhGO0FBSVBNLFdBQUtSLElBQUlDLElBQUosQ0FBU0gsSUFBVCxDQUFjSSxTQUFkLENBQXdCLFdBQXhCLEVBQXFDLGlCQUFyQyxDQUpFO0FBS1BPLG1CQUFhVCxJQUFJQyxJQUFKLENBQVNILElBQVQsQ0FBY0ksU0FBZCxDQUF3QixtQ0FBeEIsRUFBNkQsaUJBQTdEO0FBTE47QUFKSCxLQURNO0FBYVpRLGFBQVM7QUFDUmpCLFdBQU0sRUFERTtBQUVSYSxnQkFBVyxLQUZIO0FBR1JLLG1CQUFjO0FBSE4sS0FiRztBQWtCWkMsbUJBQWU7QUFDZG5CLFdBQU07QUFEUSxLQWxCSDtBQXFCWm9CLHNCQUFrQjtBQXJCTixJQUFQO0FBQUEsR0FOQTtBQTZCTkMsV0FBUztBQUNSQyxhQURRLHdCQUNLO0FBQ1osU0FBS0wsT0FBTCxDQUFhakIsSUFBYixHQUFvQixFQUFwQjtBQUNBLFNBQUtpQixPQUFMLENBQWFKLFNBQWIsR0FBeUIsS0FBekI7QUFDQSxTQUFLSyxZQUFMLEdBQW9CLEVBQXBCO0FBQ0EsU0FBSyxJQUFNSyxDQUFYLElBQWdCLEtBQUtDLFNBQXJCLEVBQWdDO0FBQy9CLFVBQUtQLE9BQUwsQ0FBYUMsWUFBYixDQUEwQixLQUFLTSxTQUFMLENBQWVELENBQWYsRUFBa0JFLEVBQTVDLElBQWtEO0FBQ2pEQyxrQkFBWSxLQUFLRixTQUFMLENBQWVELENBQWYsRUFBa0JFLEVBRG1CO0FBRWpEVixXQUFLLEVBRjRDO0FBR2pERCxlQUFTO0FBSHdDLE1BQWxEO0FBS0E7QUFDRCxTQUFLSyxhQUFMLENBQW1CbkIsSUFBbkIsR0FBMEIsSUFBMUI7QUFDQSxRQUFJLEtBQUsyQixTQUFMLENBQWUsQ0FBZixNQUFzQkMsU0FBMUIsRUFBcUM7QUFDcEMsVUFBS0QsU0FBTCxDQUFlLENBQWYsRUFBa0JFLEtBQWxCLEdBQTBCLEtBQUtaLE9BQUwsQ0FBYUosU0FBdkM7QUFDQTtBQUNELElBaEJPO0FBaUJSRixVQWpCUSxxQkFpQkU7QUFBQTs7QUFDVCxRQUFJLEtBQUttQixhQUFMLE9BQXlCLEtBQTdCLEVBQW9DO0FBQ25DO0FBQ0E7O0FBRUR2QixRQUFJd0IsSUFBSixDQUFTQyxHQUFULENBQWFDLElBQWIsQ0FBa0I7QUFDakJsQixVQUFLLHVCQURZO0FBRWpCWCxXQUFNLEtBQUthO0FBRk0sS0FBbEIsRUFHR2lCLElBSEgsQ0FHUSxvQkFBWTtBQUNuQixXQUFLQyxLQUFMLENBQVcsaUJBQVg7QUFDQSxLQUxELEVBS0dDLElBTEgsQ0FLUSxVQUFDQyxRQUFELEVBQWM7QUFDckJDLGFBQVFDLEtBQVIsQ0FBYyxrQ0FBZCxFQUFrREYsUUFBbEQ7QUFDQTlCLFNBQUl3QixJQUFKLENBQVNTLGFBQVQsQ0FBdUJDLFFBQXZCLENBQWdDbEMsSUFBSUMsSUFBSixDQUFTSCxJQUFULENBQWNJLFNBQWQsQ0FBd0IsdUNBQXhCLEVBQWlFLGlCQUFqRSxDQUFoQztBQUNBLEtBUkQ7QUFTQWlDLE1BQUUscUJBQUYsRUFBeUJDLEtBQXpCLENBQStCLE1BQS9CO0FBQ0EsSUFoQ087QUFpQ1JiLGdCQWpDUSwyQkFpQ1E7QUFDZixTQUFLWCxhQUFMLENBQW1CbkIsSUFBbkIsR0FBMEIsS0FBS2lCLE9BQUwsQ0FBYWpCLElBQWIsQ0FBa0I0QyxJQUFsQixHQUF5QkMsTUFBekIsS0FBb0MsQ0FBOUQ7O0FBRUEsV0FBTyxLQUFLMUIsYUFBTCxDQUFtQm5CLElBQTFCO0FBQ0EsSUFyQ087QUFzQ1I4QyxpQkF0Q1EsMEJBc0NPcEIsVUF0Q1AsRUFzQ21CO0FBQzFCLFNBQUtOLGdCQUFMLEdBQXdCTSxVQUF4QjtBQUNBLFFBQUksS0FBS1QsT0FBTCxDQUFhQyxZQUFiLENBQTBCUSxVQUExQixNQUEwQ0UsU0FBOUMsRUFBeUQ7QUFDeEQsVUFBS1gsT0FBTCxDQUFhQyxZQUFiLENBQTBCUSxVQUExQixJQUF3QztBQUN2Q0Esa0JBQVlBLFVBRDJCO0FBRXZDWCxXQUFLLEVBRmtDO0FBR3ZDRCxlQUFTO0FBSDhCLE1BQXhDO0FBS0E7QUFDRCxJQS9DTztBQWdEUmlDLFlBaERRLHFCQWdERTlCLE9BaERGLEVBZ0RXO0FBQ2xCLFNBQUtHLGdCQUFMLEdBQXdCLEtBQUtJLFNBQUwsQ0FBZSxDQUFmLEVBQWtCQyxFQUExQztBQUNBLFNBQUtILFVBQUw7QUFDQXpCLE9BQUdtRCxPQUFILENBQVdDLElBQVgsQ0FBZ0JQLEVBQUUscUJBQUYsQ0FBaEI7QUFDQUEsTUFBRSxxQkFBRixFQUF5QkMsS0FBekIsQ0FBK0IsTUFBL0I7QUFDQTtBQXJETyxHQTdCSDtBQW9GTk0sUUFBTTtBQUFBLFVBQVFmLE1BQVI7QUFBQTtBQXBGQSxFQUFQO0FBc0ZBLENBekZGIiwiZmlsZSI6InBhcmNlbF9zZXJ2aWNlcy9jcmVhdGUtbW9kYWwuanMiLCJzb3VyY2VzQ29udGVudCI6WyJwYXJjZWxfc2VydmljZXMuY29udHJvbGxlcnMubW9kdWxlKCdjcmVhdGUtbW9kYWwnLFxuXHRbJ3hocicsIGAke2d4LnNvdXJjZX0vbGlicy9pbmZvX21lc3NhZ2VzYCxdLFxuXHQoKSA9PiB7XG5cdFx0cmV0dXJuIHtcblx0XHRcdHZ1ZTogdHJ1ZSxcblx0XHRcdG5hbWU6ICdneC1jcmVhdGUtbW9kYWwnLFxuXHRcdFx0dGVtcGxhdGU6ICcjY3JlYXRlLW1vZGFsJyxcblx0XHRcdHBhcmVudDogJ2d4LXBhcmNlbC1zZXJ2aWNlcy1vdmVydmlldycsXG5cdFx0XHRwcm9wczogWydsYW5ndWFnZXMnXSxcblx0XHRcdGRhdGE6ICgpID0+ICh7XG5cdFx0XHRcdGxhbmc6IHtcblx0XHRcdFx0XHR0aXRsZToganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2NyZWF0ZV9tb2RhbF90aXRsZScsICdwYXJjZWxfc2VydmljZXMnKSxcblx0XHRcdFx0XHRjbG9zZToganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2NhbmNlbCcsICdidXR0b25zJyksXG5cdFx0XHRcdFx0Y29uZmlybToganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2NyZWF0ZScsICdidXR0b25zJyksXG5cdFx0XHRcdFx0bGFiZWxzOiB7XG5cdFx0XHRcdFx0XHRuYW1lOiBqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnbGFiZWxfbmFtZScsICdwYXJjZWxfc2VydmljZXMnKSxcblx0XHRcdFx0XHRcdGlzRGVmYXVsdDoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX3NldF9hc19kZWZhdWx0JywgJ3BhcmNlbF9zZXJ2aWNlcycpLFxuXHRcdFx0XHRcdFx0Y29tbWVudDoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX2NvbW1lbnQnLCAncGFyY2VsX3NlcnZpY2VzJyksXG5cdFx0XHRcdFx0XHR1cmw6IGpzZS5jb3JlLmxhbmcudHJhbnNsYXRlKCdsYWJlbF91cmwnLCAncGFyY2VsX3NlcnZpY2VzJyksXG5cdFx0XHRcdFx0XHRwbGFjZWhvbGRlcjoganNlLmNvcmUubGFuZy50cmFuc2xhdGUoJ2xhYmVsX3RyYWNraW5nX251bWJlcl9wbGFjZWhvbGRlcicsICdwYXJjZWxfc2VydmljZXMnKSxcblx0XHRcdFx0XHR9LFxuXHRcdFx0XHR9LFxuXHRcdFx0XHRkZXRhaWxzOiB7XG5cdFx0XHRcdFx0bmFtZTogJycsXG5cdFx0XHRcdFx0aXNEZWZhdWx0OiBmYWxzZSxcblx0XHRcdFx0XHRkZXNjcmlwdGlvbnM6IHt9XG5cdFx0XHRcdH0sXG5cdFx0XHRcdHZhbGlkRm9ybURhdGE6IHtcblx0XHRcdFx0XHRuYW1lOiB0cnVlLFxuXHRcdFx0XHR9LFxuXHRcdFx0XHRzZWxlY3RlZExhbmd1YWdlOiAnJyxcblx0XHRcdH0pLFxuXHRcdFx0bWV0aG9kczoge1xuXHRcdFx0XHRyZXNldE1vZGFsKCkge1xuXHRcdFx0XHRcdHRoaXMuZGV0YWlscy5uYW1lID0gJyc7XG5cdFx0XHRcdFx0dGhpcy5kZXRhaWxzLmlzRGVmYXVsdCA9IGZhbHNlO1xuXHRcdFx0XHRcdHRoaXMuZGVzY3JpcHRpb25zID0gW107XG5cdFx0XHRcdFx0Zm9yIChjb25zdCBpIGluIHRoaXMubGFuZ3VhZ2VzKSB7XG5cdFx0XHRcdFx0XHR0aGlzLmRldGFpbHMuZGVzY3JpcHRpb25zW3RoaXMubGFuZ3VhZ2VzW2ldLmlkXSA9IHtcblx0XHRcdFx0XHRcdFx0bGFuZ3VhZ2VJZDogdGhpcy5sYW5ndWFnZXNbaV0uaWQsXG5cdFx0XHRcdFx0XHRcdHVybDogJycsXG5cdFx0XHRcdFx0XHRcdGNvbW1lbnQ6ICcnLFxuXHRcdFx0XHRcdFx0fTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0dGhpcy52YWxpZEZvcm1EYXRhLm5hbWUgPSB0cnVlO1xuXHRcdFx0XHRcdGlmICh0aGlzLiRjaGlsZHJlblswXSAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRcdFx0XHR0aGlzLiRjaGlsZHJlblswXS5pbnB1dCA9IHRoaXMuZGV0YWlscy5pc0RlZmF1bHQ7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9LFxuXHRcdFx0XHRjb25maXJtKCkge1xuXHRcdFx0XHRcdGlmICh0aGlzLmNoZWNrRm9ybURhdGEoKSA9PT0gZmFsc2UpIHtcblx0XHRcdFx0XHRcdHJldHVybjtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0XG5cdFx0XHRcdFx0anNlLmxpYnMueGhyLnBvc3Qoe1xuXHRcdFx0XHRcdFx0dXJsOiAnLi9hcGkvcGFyY2VsLXNlcnZpY2VzJyxcblx0XHRcdFx0XHRcdGRhdGE6IHRoaXMuZGV0YWlsc1xuXHRcdFx0XHRcdH0pLmRvbmUocmVzcG9uc2UgPT4ge1xuXHRcdFx0XHRcdFx0dGhpcy4kZW1pdCgncmVsb2FkLW92ZXJ2aWV3Jyk7XG5cdFx0XHRcdFx0fSkuZmFpbCgocmVzcG9uc2UpID0+IHtcblx0XHRcdFx0XHRcdGNvbnNvbGUuZXJyb3IoJ0NvdWxkIG5vdCBjcmVhdGUgcGFyY2VsIHNlcnZpY2UuJywgcmVzcG9uc2UpO1xuXHRcdFx0XHRcdFx0anNlLmxpYnMuaW5mb19tZXNzYWdlcy5hZGRFcnJvcihqc2UuY29yZS5sYW5nLnRyYW5zbGF0ZSgnZXJyb3JfY291bGRfbm90X2NyZWF0ZV9wYXJjZWxfc2VydmljZScsICdwYXJjZWxfc2VydmljZXMnKSk7XG5cdFx0XHRcdFx0fSk7XG5cdFx0XHRcdFx0JCgnLmNyZWF0ZS1tb2RhbC5tb2RhbCcpLm1vZGFsKCdoaWRlJyk7XG5cdFx0XHRcdH0sXG5cdFx0XHRcdGNoZWNrRm9ybURhdGEoKSB7XG5cdFx0XHRcdFx0dGhpcy52YWxpZEZvcm1EYXRhLm5hbWUgPSB0aGlzLmRldGFpbHMubmFtZS50cmltKCkubGVuZ3RoICE9PSAwO1xuXHRcdFx0XHRcdFxuXHRcdFx0XHRcdHJldHVybiB0aGlzLnZhbGlkRm9ybURhdGEubmFtZTtcblx0XHRcdFx0fSxcblx0XHRcdFx0Y2hhbmdlTGFuZ3VhZ2UobGFuZ3VhZ2VJZCkge1xuXHRcdFx0XHRcdHRoaXMuc2VsZWN0ZWRMYW5ndWFnZSA9IGxhbmd1YWdlSWQ7XG5cdFx0XHRcdFx0aWYgKHRoaXMuZGV0YWlscy5kZXNjcmlwdGlvbnNbbGFuZ3VhZ2VJZF0gPT09IHVuZGVmaW5lZCkge1xuXHRcdFx0XHRcdFx0dGhpcy5kZXRhaWxzLmRlc2NyaXB0aW9uc1tsYW5ndWFnZUlkXSA9IHtcblx0XHRcdFx0XHRcdFx0bGFuZ3VhZ2VJZDogbGFuZ3VhZ2VJZCxcblx0XHRcdFx0XHRcdFx0dXJsOiAnJyxcblx0XHRcdFx0XHRcdFx0Y29tbWVudDogJycsXG5cdFx0XHRcdFx0XHR9O1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSxcblx0XHRcdFx0b3Blbk1vZGFsKGRldGFpbHMpIHtcblx0XHRcdFx0XHR0aGlzLnNlbGVjdGVkTGFuZ3VhZ2UgPSB0aGlzLmxhbmd1YWdlc1swXS5pZDtcblx0XHRcdFx0XHR0aGlzLnJlc2V0TW9kYWwoKTtcblx0XHRcdFx0XHRneC53aWRnZXRzLmluaXQoJCgnLmNyZWF0ZS1tb2RhbC5tb2RhbCcpKTtcblx0XHRcdFx0XHQkKCcuY3JlYXRlLW1vZGFsLm1vZGFsJykubW9kYWwoJ3Nob3cnKTtcblx0XHRcdFx0fSxcblx0XHRcdH0sXG5cdFx0XHRpbml0OiBkb25lID0+IGRvbmUoKVxuXHRcdH1cblx0fSk7Il19
